// config: norepeat noautolaunch

#include "GetObjects.js"
#include "WaitForDialogDone.js"

function DoRemoveDuplicates()
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowStandaloneCurves();
	objectpicker.allowPointObjects();
	
	if ( !GetObjects( objectpicker ) )
		return;
		
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectPrompt' );
	moi.ui.showUI( 'OptionsPrompt' );
	moi.ui.showUI( 'RemoveDuplicatesOptions' );
	moi.ui.endUIUpdate();
	
	if ( !WaitForDialogDone() )
		return;
		
	var factory = moi.command.createFactory( 'removeduplicates' );
	factory.setInput( 0, objectpicker.objects );
	factory.setInput( 1, moi.ui.commandUI.tol.value );
	
	factory.commit();
}

DoRemoveDuplicates();
